<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Consulting Services</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Bootstrap CSS -->
    <link href="{{ asset('front/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="icon" href="{{ getFaviconUrl() }}" type="image/png">
    {{-- css link --}}
    <link rel="stylesheet" href="{{ asset('assets/css/vcard23.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick-theme.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/custom.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/third-party.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom-vcard.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/lightbox.css') }}">
</head>

<body>
    <div class="container p-0">
        <div class="main-content mx-auto w-100 overflow-hidden">
            <div class="banner-section position-relative">
                <div class="banner-img">
                    <img src="{{ asset('assets/img/vcard23/banner-img.png') }}" class="banner-img" />
                </div>
                <div class="d-flex justify-content-end position-absolute top-0 end-0 me-3">
                    <div class="language pt-3 me-2">
                        <ul class="text-decoration-none">
                            <li class="dropdown1 dropdown lang-list">
                                <a class="dropdown-toggle lang-head text-decoration-none" data-toggle="dropdown"
                                    role="button" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa-solid fa-language me-2"></i>Language</a>
                                <ul class="dropdown-menu start-0 lang-hover-list top-100 mt-0">
                                    <li>
                                        <img src="{{ asset('assets/img/vcard1/english.png') }}" width="25px"
                                            height="20px" class="me-3"><a href="#">English</a>
                                    </li>
                                    <li>
                                        <img src="{{ asset('assets/img/vcard1/spain.png') }}" width="25px"
                                            height="20px" class="me-3"><a href="#">Spanish</a>
                                    </li>
                                    <li>
                                        <img src="{{ asset('assets/img/vcard1/france.png') }}" width="25px"
                                            height="20px" class="me-3"><a href="#">Franch</a>
                                    </li>
                                    <li>
                                        <img src="{{ asset('assets/img/vcard1/arabic.svg') }}" width="25px"
                                            height="20px" class="me-3"><a href="#">Arabic</a>
                                    </li>
                                    <li>
                                        <img src="{{ asset('assets/img/vcard1/german.png') }}" width="25px"
                                            height="20px" class="me-3"><a href="#">German</a>
                                    </li>
                                    <li>
                                        <img src="{{ asset('assets/img/vcard1/russian.jpeg') }}" width="25px"
                                            height="20px" class="me-3"><a href="#">russian</a>
                                    </li>
                                    <li>
                                        <img src="{{ asset('assets/img/vcard1/turkish.png') }}" width="25px"
                                            height="20px" class="me-3"><a href="#">Turkish</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="overlay"></div>
            </div>
            <div class="profile-section px-40">
                <div class="card d-flex flex-sm-row align-items-sm-end align-items-center mb-40">
                    <div class="card-img me-sm-2">
                        <img src="{{ asset('assets/img/vcard23/profile-img.png') }}" class="w-100 h-100 object-fit-cover" />
                    </div>
                    <div class="card-body text-sm-start text-center">
                        <div class="profile-name">
                            <h2 class="text-secondary mb-0 fs-28 fw-6">Leslie Alexander</h2>
                            <p class="fs-18 text-gray-100">Business Consultant</p>
                            <div class="social-media d-flex justify-content-sm-start justify-content-center">
                                <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                    <svg width="13" height="25" viewBox="0 0 13 25" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M3.73824 14.1111C3.18372 14.1111 2.67459 14.1111 2.16547 14.1111C1.73123 14.1111 1.297 14.1193 0.863524 14.1079C0.409622 14.0964 0.261348 13.9495 0.257565 13.4638C0.24773 12.1912 0.246974 10.9179 0.258322 9.64528C0.262861 9.16368 0.421726 9.01103 0.869577 9.00777C1.7093 9.00205 2.54901 9.00613 3.38949 9.00613C3.49237 9.00613 3.59526 9.00613 3.73824 9.00613C3.73824 8.86818 3.73673 8.74982 3.73824 8.63228C3.75791 7.47235 3.71706 6.30752 3.80935 5.15412C4.04311 2.21633 6.12123 0.1185 8.85372 0.0229951C9.96578 -0.0161863 11.0809 0.00585325 12.1937 0.00911836C12.5855 0.00993464 12.7444 0.182986 12.7459 0.60745C12.7512 1.7984 12.7512 2.99017 12.7467 4.18111C12.7452 4.63741 12.5969 4.80312 12.1619 4.81373C11.3978 4.83332 10.6338 4.83332 9.86894 4.84638C9.01183 4.86026 8.65173 5.22187 8.63357 6.13528C8.61542 7.05849 8.62979 7.98334 8.62979 8.94246C8.75915 8.94246 8.85977 8.94246 8.96038 8.94246C9.93249 8.94246 10.9046 8.94083 11.8767 8.94328C12.4895 8.9441 12.6332 9.09756 12.634 9.74731C12.6347 10.9587 12.6362 12.1708 12.6332 13.3822C12.6317 13.9242 12.4993 14.0703 11.994 14.0728C10.8902 14.0777 9.78649 14.0744 8.63055 14.0744C8.63055 14.2164 8.63055 14.343 8.63055 14.4687C8.63055 17.6554 8.63055 20.843 8.63055 24.0297C8.63055 24.908 8.54431 24.9995 7.71669 24.9995C6.63111 24.9995 5.54628 25.0011 4.4607 24.9986C3.8797 24.9978 3.73824 24.8468 3.73824 24.2265C3.73748 20.9883 3.73748 17.7501 3.73748 14.5127C3.73824 14.3928 3.73824 14.2728 3.73824 14.1111Z"
                                            fill="#F96921" />
                                    </svg>
                                </a>
                                <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M25 11.2256C25 11.7143 25 12.2024 25 12.6912C24.9608 13.0129 24.9289 13.3352 24.8818 13.6557C24.5001 16.2479 23.401 18.4908 21.5606 20.3588C19.5879 22.3613 17.1968 23.5418 14.4032 23.8654C11.9606 24.1486 9.63499 23.7204 7.44909 22.5821C7.29838 22.5039 7.17034 22.4733 6.99451 22.5363C5.70062 22.9999 4.40059 23.4458 3.10363 23.9015C2.06827 24.2648 1.03475 24.6336 0 25C0.0214424 24.8979 0.0312446 24.792 0.0655525 24.6942C0.831352 22.5008 1.59593 20.3062 2.37398 18.1171C2.46526 17.8608 2.45852 17.662 2.3311 17.4137C1.15666 15.1286 0.770088 12.7022 1.14686 10.1693C1.52547 7.62363 2.62516 5.4119 4.44715 3.58796C7.14951 0.883244 10.4339 -0.285619 14.2347 0.0587402C16.545 0.267925 18.6224 1.12056 20.4358 2.57323C22.7976 4.46446 24.2746 6.89393 24.8101 9.87878C24.8897 10.3247 24.9375 10.7767 25 11.2256ZM10.2899 9.86716C10.3052 9.84025 10.3077 9.83169 10.3132 9.82618C10.6287 9.50812 10.946 9.19251 11.2591 8.87262C11.6267 8.49645 11.6267 8.09215 11.2554 7.71721C10.7224 7.17957 10.187 6.64377 9.64785 6.11163C9.26802 5.73669 8.86796 5.73669 8.48935 6.10918C8.09481 6.49758 7.71498 6.90127 7.31063 7.27927C6.85299 7.70743 6.71698 8.23161 6.77886 8.8298C6.8824 9.82435 7.29287 10.7082 7.80013 11.5468C9.11915 13.7267 10.8688 15.4986 12.9929 16.9005C13.8518 17.4675 14.764 17.9324 15.7871 18.1391C16.5737 18.2981 17.2673 18.185 17.826 17.5391C18.1446 17.1709 18.514 16.8461 18.8583 16.4993C19.2528 16.1011 19.2522 15.7072 18.8546 15.3066C18.3498 14.7983 17.8413 14.2931 17.334 13.7872C16.8684 13.323 16.5008 13.3218 16.0377 13.7836C15.7338 14.0869 15.4312 14.3915 15.131 14.6925C12.9506 13.6251 11.3485 12.0251 10.2899 9.86716Z"
                                            fill="#F96921" />
                                    </svg>
                                </a>
                                <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M24.9835 15.1365C24.9754 13.9763 24.8597 12.8225 24.5223 11.7014C24.1002 10.2974 23.3351 9.16808 21.9702 8.52394C20.9158 8.02657 19.7914 7.88714 18.6425 7.92139C16.6314 7.98173 15.0042 8.75795 13.9164 10.5126C13.9042 10.5322 13.8716 10.5395 13.8031 10.5787C13.8031 9.80814 13.8031 9.07187 13.8031 8.33478C12.1303 8.33478 10.4982 8.33478 8.87012 8.33478C8.87012 13.9037 8.87012 19.4506 8.87012 25C10.5935 25 12.2892 25 14.0288 25C14.0288 24.8475 14.0288 24.7269 14.0288 24.6054C14.0288 22.0011 14.0215 19.396 14.0346 16.7917C14.037 16.2136 14.0745 15.6315 14.1568 15.0599C14.3817 13.4928 15.1786 12.6456 16.6257 12.4744C18.2155 12.2868 19.3253 12.8666 19.6398 14.5731C19.7514 15.1798 19.8003 15.8051 19.8044 16.4224C19.8223 19.149 19.8142 21.8755 19.815 24.6021C19.815 24.7195 19.815 24.8361 19.815 24.9478C21.5669 24.9478 23.2699 24.9478 24.9884 24.9478C24.9933 24.8793 25.0006 24.8304 25.0006 24.7807C24.9965 21.5665 25.0047 18.3515 24.9835 15.1365Z"
                                            fill="#F96921" />
                                        <path
                                            d="M0.430664 24.9886C2.1573 24.9886 3.86764 24.9886 5.58369 24.9886C5.58369 19.427 5.58369 13.8882 5.58369 8.33069C3.86357 8.33069 2.16056 8.33069 0.430664 8.33069C0.430664 13.8988 0.430664 19.4384 0.430664 24.9886Z"
                                            fill="#F96921" />
                                        <path
                                            d="M2.98067 0.000119092C1.34204 0.0147956 -0.000814466 1.3683 3.70634e-07 3.00392C0.000815207 4.66726 1.37381 6.0436 3.02223 6.03381C4.66168 6.02403 6.00616 4.65014 5.99638 2.99251C5.98742 1.32916 4.63316 -0.0145575 2.98067 0.000119092Z"
                                            fill="#F96921" />
                                    </svg>
                                </a>
                                <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M24.9972 5.76124C24.9972 10.253 24.9972 14.744 24.9972 19.2357C24.8986 19.7027 24.8405 20.1834 24.6945 20.6351C23.8431 23.262 21.4807 24.9855 18.7086 24.9931C14.5676 25.0046 10.4267 24.9992 6.28576 24.9947C4.95589 24.9931 3.72997 24.6255 2.65308 23.8383C0.873808 22.5375 0.000985528 20.7681 0.000985528 18.5662C0.000221236 14.5391 -0.00207164 10.5121 0.00480699 6.48502C0.00557128 6.07231 0.0246786 5.65194 0.098815 5.24687C0.518412 2.93718 1.8307 1.32605 3.99824 0.444054C4.55388 0.217823 5.17219 0.143687 5.76146 0C10.2532 0 14.7442 0 19.2359 0C19.411 0.031336 19.5867 0.0603791 19.761 0.0932437C22.0554 0.526598 23.662 1.8259 24.5455 3.97738C24.7771 4.53913 24.8512 5.16509 24.9972 5.76124ZM22.8992 12.4985C22.9022 12.4985 22.9053 12.4985 22.9084 12.4985C22.9084 10.4647 22.9045 8.43091 22.9107 6.39637C22.9122 5.74442 22.8251 5.11159 22.5339 4.52538C21.7451 2.93641 20.4588 2.09645 18.6803 2.09034C14.5554 2.07582 10.4305 2.08499 6.30564 2.08805C6.06259 2.08805 5.81802 2.11098 5.57803 2.14537C3.68488 2.41211 2.11731 4.12412 2.10508 6.04097C2.0768 10.2958 2.09362 14.5506 2.09133 18.8054C2.09133 19.3832 2.20444 19.9412 2.45895 20.4578C3.2584 22.0774 4.56916 22.9043 6.37824 22.9066C10.4542 22.9127 14.5302 22.9097 18.6062 22.9059C18.8813 22.9059 19.1587 22.8845 19.4316 22.847C21.2881 22.5925 22.8671 20.8614 22.8923 18.9896C22.9221 16.8267 22.8992 14.663 22.8992 12.4985Z"
                                            fill="#F96921" />
                                        <path
                                            d="M18.7465 12.529C18.7136 15.9898 15.8788 18.7909 12.4548 18.7458C8.99792 18.7007 6.21742 15.8873 6.25029 12.4664C6.28315 9.00413 9.11562 6.20605 12.5412 6.24962C15.9988 6.29471 18.7793 9.10807 18.7465 12.529ZM12.5022 8.33766C10.2032 8.33384 8.34751 10.1834 8.33834 12.4885C8.3284 14.7845 10.1765 16.644 12.4831 16.6593C14.7859 16.6738 16.6615 14.8043 16.6592 12.4962C16.6569 10.1941 14.8043 8.34149 12.5022 8.33766Z"
                                            fill="#F96921" />
                                        <path
                                            d="M19.2807 7.28218C18.4109 7.2883 17.7139 6.59661 17.7139 5.72761C17.7146 4.87237 18.3987 4.18068 19.257 4.16693C20.1046 4.15317 20.8322 4.87466 20.8314 5.72838C20.8314 6.57903 20.1351 7.27607 19.2807 7.28218Z"
                                            fill="#F96921" />
                                    </svg>
                                </a>
                                <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_1344_384)">
                                            <path
                                                d="M7.3889 18.6214C5.04233 18.3168 3.48547 17.2112 2.60551 15C3.36137 15 4.02699 15 4.68132 15C2.3009 14.0636 0.958396 12.4278 0.789172 9.83305C1.51119 10.0361 2.17681 10.2279 2.84242 10.4084C2.87627 10.3633 2.91011 10.3182 2.94395 10.273C1.95118 9.47204 1.24044 8.47926 0.99224 7.21572C0.744045 5.95219 0.856861 4.73378 1.54504 3.48152C4.388 6.71934 7.86273 8.60336 12.1384 8.87412C12.1384 8.40029 12.1272 7.99415 12.1384 7.58802C12.2061 5.43323 13.2666 3.86509 15.1958 2.99641C17.0798 2.15029 18.93 2.37592 20.5545 3.70715C21.0058 4.07944 21.4119 4.15841 21.9196 3.95535C22.698 3.65074 23.4764 3.34614 24.3226 3.03026C23.9616 4.15841 23.217 4.92556 22.4385 5.7604C23.2508 5.54605 24.0631 5.32042 24.8754 5.10607C24.9092 5.13991 24.9543 5.17376 24.9882 5.2076C24.3451 5.87322 23.7359 6.59524 23.0365 7.19316C22.6529 7.52033 22.5062 7.84749 22.4949 8.3326C22.4273 11.7284 21.4119 14.8082 19.3135 17.4933C16.4931 21.1146 12.7477 22.9423 8.13348 23.0325C5.49359 23.0889 3.02293 22.5361 0.698919 21.2839C0.473287 21.1598 0.247656 21.0244 0.0107422 20.8326C2.68448 20.9567 5.1213 20.3249 7.3889 18.6214Z"
                                                fill="#F96921" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1344_384">
                                                <rect width="25" height="20.5325" fill="white"
                                                    transform="translate(0 2.5)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <p class="text-gray-100 profile-desc pb-60 mb-sm-0 fs-14 text-center">
                    Lorem Ipsum is simply dummy text of the printing and typesetting
                    industry. Lorem Ipsum has been the industry's standard dummy text
                    ever since the 1500s, when an unknown printer took a galley of type
                    and scrambled it to make a type specimen book.
                </p>
            </div>
            <div class="contact-section px-40 mx-md-3">
                <div class="row">
                    <div class="col-sm-6 mb-5 px-lg-4 px-sm-3">
                        <div class="contact-box">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="22" height="17" viewBox="0 0 22 17" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_1371_424)">
                                        <path
                                            d="M11.0212 -0.000352881C13.8227 -0.000352881 16.6185 -0.00602144 19.4199 0.00531567C19.7863 0.00531567 20.1583 0.0449956 20.5134 0.124355C21.1503 0.271738 21.59 0.679874 21.8662 1.2694C22.1086 1.78524 22.0297 2.06867 21.5562 2.3691C20.9418 2.76023 20.3218 3.1457 19.7074 3.53683C17.0243 5.2544 14.3412 6.96063 11.6694 8.68954C11.1847 9.00698 10.8014 8.99564 10.3166 8.68387C7.06426 6.58084 3.79498 4.50615 0.53134 2.42012C0.4637 2.37477 0.390423 2.33509 0.328419 2.28974C0.00712795 2.06867 -0.0548757 1.89294 0.0578581 1.52449C0.334056 0.61752 1.02173 0.090344 2.0307 0.0336585C2.43654 0.0109842 2.84238 0.0109842 3.24259 0.00531567C5.83546 0.00531567 8.42834 0.00531567 11.0212 -0.000352881C11.0212 0.00531567 11.0212 -0.000352881 11.0212 -0.000352881Z"
                                            fill="white" />
                                        <path
                                            d="M10.9749 17C8.1284 17 5.28751 17.0057 2.44098 16.9944C2.08587 16.9944 1.71949 16.9547 1.37565 16.8583C0.682335 16.6599 0.253947 16.1667 0.045389 15.4809C-0.0617081 15.1237 0.000295491 14.948 0.321587 14.7439C2.94828 13.0831 5.57498 11.4222 8.20168 9.76127C8.47788 9.58555 8.77099 9.58555 9.04718 9.74994C9.54321 10.0447 10.028 10.3508 10.5127 10.6626C10.9129 10.9233 11.082 10.929 11.471 10.6739C11.9839 10.3395 12.5025 10.0164 13.0154 9.68191C13.2916 9.50052 13.5396 9.55721 13.7933 9.72159C14.6331 10.2658 15.473 10.8043 16.3185 11.3428C18.0433 12.4425 19.7738 13.5309 21.4986 14.6306C22.0285 14.965 22.113 15.2428 21.8537 15.804C21.4986 16.5635 20.8561 16.8867 20.0725 16.983C19.8753 17.0057 19.678 17.0057 19.4807 17.0057C16.6454 17 13.8102 17 10.9749 17Z"
                                            fill="white" />
                                        <path
                                            d="M0.0400391 13.0604C0.0400391 10.0107 0.0400391 7.01202 0.0400391 3.96234C2.41872 5.48718 4.76359 6.98368 7.14791 8.50852C4.76922 10.0334 2.42436 11.5355 0.0400391 13.0604Z"
                                            fill="white" />
                                        <path
                                            d="M14.8701 8.50852C17.2432 6.98935 19.588 5.48718 21.9667 3.96234C21.9667 7.00069 21.9667 9.99368 21.9667 13.049C19.5937 11.5355 17.2488 10.0334 14.8701 8.50852Z"
                                            fill="white" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_1371_424">
                                            <rect width="22" height="17" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="mailto:jackie@gmail.com"
                                    class="text-secondary fs-14 fw-5">jackie@gmail.com</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-5 px-lg-4 px-sm-3">
                        <div class="contact-box">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.03788 8.65636C5.68074 11.8074 8.01407 14.1974 11.0974 15.8383C11.2284 15.9096 11.5379 15.8264 11.6688 15.7075C12.3712 15.0416 13.0617 14.3639 13.7284 13.6623C14.0974 13.2699 14.5022 13.2105 15.0141 13.3056C16.2284 13.5196 17.4545 13.7337 18.6807 13.8763C19.6569 13.9952 20.0022 14.3163 20.0022 15.3151C20.0022 16.3853 20.0022 17.4435 20.0022 18.5137C20.0022 19.6671 19.6331 20.0238 18.4545 20C10.0736 19.8573 2.57359 13.912 0.597401 5.75505C0.252163 4.31629 0.14502 2.80618 0.0140678 1.31986C-0.0692655 0.439952 0.41883 0.0118906 1.29978 0.0118906C2.46645 0 3.63312 0 4.79978 0C5.65693 0 6.01407 0.39239 6.12121 1.24851C6.28788 2.50892 6.51407 3.76932 6.75216 5.01784C6.8474 5.55291 6.75216 5.98098 6.35931 6.36147C5.57359 7.12247 4.81169 7.88347 4.03788 8.65636Z"
                                        fill="white" />
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="tel:+1 4078461474" class="text-secondary fs-14 fw-5">+1 4078461474</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-sm-0 mb-5 px-lg-4 px-sm-3">
                        <div class="contact-box">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="23" height="20" viewBox="0 0 23 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_1371_435)">
                                        <path
                                            d="M0.299472 20C0.202874 19.8165 0.0483171 19.6427 0.0193377 19.4495C-0.0289614 19.1019 0.0193377 18.7446 1.80406e-05 18.3969C-0.00964177 18.0782 0.125595 17.9141 0.454029 17.9237C0.550627 17.9237 0.647225 17.9237 0.743823 17.9237C7.92106 17.9237 15.0886 17.9237 22.2659 17.9334C22.5074 17.9334 22.7489 18.0299 22.9904 18.0782C22.9904 18.7156 22.9904 19.3626 22.9904 20C15.4364 20 7.8631 20 0.299472 20Z"
                                            fill="white" />
                                        <path
                                            d="M11.5246 8.18927C14.1037 8.18927 16.6829 8.18927 19.2717 8.18927C20.7304 8.18927 21.4452 8.91356 21.4548 10.3814C21.4548 10.4008 21.4548 10.4104 21.4548 10.4297C21.6287 11.2796 21.2327 11.7624 20.4792 12.0908C19.7161 12.4191 18.9819 12.4867 18.3154 11.9169C17.987 11.6369 17.7165 11.2989 17.446 10.9609C17.0886 10.5263 16.7505 10.5166 16.3834 10.9416C16.1419 11.2216 15.9005 11.5017 15.63 11.7431C14.8669 12.4288 14.0265 12.506 13.1667 11.9556C12.7803 11.7045 12.4326 11.3858 12.0945 11.0671C11.6308 10.6325 11.428 10.6325 10.974 11.0864C10.7131 11.3472 10.4427 11.5983 10.1432 11.8107C9.12893 12.5447 8.21125 12.4964 7.26459 11.6852C7.11969 11.5596 6.98445 11.4244 6.85887 11.2796C6.21167 10.536 6.07643 10.536 5.42922 11.3085C4.55018 12.3515 3.4393 12.5833 2.20285 12.0232C1.71986 11.8011 1.53632 11.4631 1.58462 10.9609C1.6136 10.7194 1.64258 10.478 1.6136 10.2462C1.44938 9.05842 2.4057 8.16996 3.64216 8.17961C6.25997 8.20858 8.88743 8.18927 11.5246 8.18927Z"
                                            fill="white" />
                                        <path
                                            d="M21.2613 16.62C14.7602 16.62 8.28816 16.62 1.78711 16.62C1.78711 15.606 1.78711 14.592 1.78711 13.5394C3.4003 14.0802 4.81063 13.7325 5.96981 12.4867C7.90177 14.3409 9.67917 14.0898 11.5435 12.4288C13.8522 14.4375 15.5137 13.9739 17.0882 12.3998C17.6195 12.9696 18.1991 13.4911 18.9912 13.6939C19.7737 13.8967 20.5078 13.7325 21.2806 13.4042C21.2613 14.4858 21.2613 15.5287 21.2613 16.62Z"
                                            fill="white" />
                                        <path
                                            d="M10.143 7.2815C10.143 6.32544 10.1334 5.3887 10.1527 4.44229C10.1624 4.13326 10.3845 3.94978 10.7033 3.94978C11.2346 3.94012 11.7659 3.94012 12.2875 3.94978C12.6546 3.94978 12.8671 4.16224 12.8671 4.51955C12.8864 5.42732 12.8768 6.34475 12.8768 7.2815C11.9591 7.2815 11.0704 7.2815 10.143 7.2815Z"
                                            fill="white" />
                                        <path
                                            d="M11.5149 0C11.7467 0.424916 12.0172 0.907774 12.278 1.40029C12.3939 1.6224 12.5485 1.84452 12.6161 2.08595C12.761 2.61709 12.5292 3.19652 12.1138 3.4283C11.6984 3.66007 11.0609 3.59247 10.7228 3.28344C10.3654 2.94544 10.2495 2.29841 10.5006 1.82521C10.8291 1.18783 11.1865 0.569773 11.5149 0Z"
                                            fill="white" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_1371_435">
                                            <rect width="23" height="20" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="mb-0 text-secondary fs-14 fw-5">12th June, 1990</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 px-lg-4 px-sm-3">
                        <div class="contact-box">
                            <div class="contact-icon d-flex justify-content-center align-items-center">
                                <svg width="17" height="22" viewBox="0 0 17 22" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_1371_458)">
                                        <path
                                            d="M8.49485 18.0444C8.21021 17.7124 7.93674 17.3974 7.66885 17.0796C6.22334 15.3486 4.85598 13.5581 3.67278 11.6314C3.13979 10.7659 2.67377 9.86637 2.27472 8.92712C1.54081 7.19334 1.66638 5.48793 2.47564 3.83644C3.52209 1.70256 5.23828 0.43131 7.56002 0.0766086C11.1319 -0.468213 14.5252 2.07996 15.1084 5.68089C15.2982 6.86134 15.1168 7.96801 14.662 9.05197C14.1541 10.2608 13.4983 11.3845 12.7839 12.4713C11.5086 14.4065 10.0827 16.2198 8.56461 17.9621C8.54787 17.9819 8.52834 18.0046 8.49485 18.0444ZM11.8519 6.23706C11.8547 4.35856 10.3478 2.82909 8.49764 2.82909C6.64472 2.82909 5.14061 4.35573 5.14061 6.23423C5.14061 8.11272 6.64472 9.6422 8.49485 9.6422C10.345 9.6422 11.8491 8.1184 11.8519 6.23706Z"
                                            fill="white" />
                                        <path
                                            d="M5.8846 15.7317C5.5609 15.78 5.23998 15.8254 4.92186 15.8821C3.96191 16.0495 3.0215 16.2851 2.13411 16.7079C1.78808 16.8753 1.45879 17.0682 1.18811 17.3492C0.752787 17.8032 0.752787 18.2686 1.19927 18.7141C1.57879 19.0943 2.05039 19.3156 2.53874 19.5086C3.48473 19.8775 4.47258 20.079 5.47439 20.2152C6.85571 20.4053 8.2454 20.4507 9.63788 20.3826C11.1978 20.306 12.741 20.1073 14.2283 19.5909C14.6692 19.4377 15.099 19.256 15.4785 18.9723C15.6487 18.8446 15.8134 18.697 15.9445 18.5296C16.1985 18.2061 16.2068 17.8458 15.9445 17.5308C15.7659 17.3151 15.5455 17.1193 15.3111 16.9661C14.6553 16.5376 13.9186 16.2936 13.1651 16.1176C12.54 15.9729 11.9066 15.8793 11.2759 15.7629C11.2201 15.7516 11.1671 15.7431 11.1113 15.7346C11.2145 15.5132 11.2341 15.5076 11.4601 15.5246C12.3922 15.5984 13.3214 15.7005 14.2339 15.9077C14.7306 16.0183 15.2218 16.1517 15.671 16.3929C15.9529 16.5433 16.2319 16.7192 16.4636 16.9349C17.0579 17.4911 17.164 18.2629 16.7845 18.9893C16.5808 19.3809 16.2822 19.6902 15.9417 19.9598C15.1994 20.5472 14.3539 20.9359 13.4665 21.2339C11.5996 21.861 9.67695 22.0681 7.71799 21.983C6.21388 21.9149 4.74327 21.668 3.32009 21.1516C2.44386 20.8338 1.60948 20.4365 0.895105 19.8122C0.582564 19.5398 0.317462 19.222 0.150029 18.8332C-0.131816 18.1778 -0.00345087 17.4854 0.490476 16.9774C0.903476 16.5518 1.42531 16.3163 1.96946 16.1318C2.71454 15.8793 3.48473 15.7488 4.2605 15.6523C4.69025 15.5984 5.11999 15.5672 5.55252 15.5218C5.76182 15.5019 5.77856 15.5132 5.8846 15.7317Z"
                                            fill="white" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_1371_458">
                                            <rect width="17" height="22" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="text-secondary mb-0 fs-14 fw-5">New York, USA</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="our-services-section px-40 pt-60">
                <div class="services-bg-img text-center">
                    <img src="{{ asset('assets/img/vcard23/services-bg-img.png') }}" alt="services-bg-img" />
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="text-center mb-0">Our Services</h2>
                </div>
                <div class="services">
                    <div class="row">
                        <div class="col-sm-6 mb-sm-2 mb-5 mt-2 px-sm-3">
                            <div class="service-card h-100">
                                <div class="card-img mx-auto d-flex justify-content-center align-items-center mb-3">
                                    <img src="{{ asset('assets/img/vcard23/strategy.png') }}" class="h-100" />
                                </div>
                                <div class="card-body text-center p-0 pt-2 flex-grow-0">
                                    <h3 class="card-title fs-18 text-secondary">
                                        Strategy consulting
                                    </h3>
                                    <p class="mb-0 fs-14 text-gray-100 text-center">
                                        There are many variations of passages of Lorem Ipsum but
                                        the majority have suffered alteration in some form
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 mt-2 mb-2 px-sm-3">
                            <div class="service-card h-100">
                                <div class="card-img mx-auto d-flex justify-content-center align-items-center mb-3">
                                    <img src="{{ asset('assets/img/vcard23/marketing.png') }}" class="h-100" />
                                </div>
                                <div class="card-body text-center p-0 pt-2 flex-grow-0">
                                    <h3 class="card-title fs-18 text-secondary">
                                        Marketing consulting
                                    </h3>
                                    <p class="mb-0 fs-14 text-gray-100 text-center">
                                        There are many variations of passages of Lorem Ipsum but
                                        the majority have suffered alteration in some form
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="appointment-section pt-60 px-40">
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Make an Appointment</h2>
                </div>

                <div class="appointment px-2">
                    <div class="mb-20">
                        <label for="date" class="appoint-date text-secondary fs-6 fw-5 mb-1">Date:</label>
                        <div class="row">
                            <div class="col-12 px-2">
                                <div class="position-relative">
                                    <input type="text" class="form-control appointment-input"
                                        placeholder="Pick a date" />
                                    <span class="calendar-icon"><svg width="20" height="20"
                                            viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M6.25 9.375V10.625C6.25 10.9705 5.97047 11.25 5.625 11.25H4.375C4.02953 11.25 3.75 10.9705 3.75 10.625V9.375C3.75 9.02953 4.02953 8.75 4.375 8.75H5.625C5.97047 8.75 6.25 9.02953 6.25 9.375ZM5.625 13.75H4.375C4.02953 13.75 3.75 14.0295 3.75 14.375V15.625C3.75 15.9705 4.02953 16.25 4.375 16.25H5.625C5.97047 16.25 6.25 15.9705 6.25 15.625V14.375C6.25 14.0295 5.97047 13.75 5.625 13.75ZM10.625 8.75H9.375C9.02953 8.75 8.75 9.02953 8.75 9.375V10.625C8.75 10.9705 9.02953 11.25 9.375 11.25H10.625C10.9705 11.25 11.25 10.9705 11.25 10.625V9.375C11.25 9.02953 10.9705 8.75 10.625 8.75ZM10.625 13.75H9.375C9.02953 13.75 8.75 14.0295 8.75 14.375V15.625C8.75 15.9705 9.02953 16.25 9.375 16.25H10.625C10.9705 16.25 11.25 15.9705 11.25 15.625V14.375C11.25 14.0295 10.9705 13.75 10.625 13.75ZM15.625 8.75H14.375C14.0295 8.75 13.75 9.02953 13.75 9.375V10.625C13.75 10.9705 14.0295 11.25 14.375 11.25H15.625C15.9705 11.25 16.25 10.9705 16.25 10.625V9.375C16.25 9.02953 15.9705 8.75 15.625 8.75ZM15.625 13.75H14.375C14.0295 13.75 13.75 14.0295 13.75 14.375V15.625C13.75 15.9705 14.0295 16.25 14.375 16.25H15.625C15.9705 16.25 16.25 15.9705 16.25 15.625V14.375C16.25 14.0295 15.9705 13.75 15.625 13.75ZM4.375 3.75H5.625C5.97047 3.75 6.25 3.47047 6.25 3.125V0.625C6.25 0.279531 5.97047 0 5.625 0H4.375C4.02953 0 3.75 0.279531 3.75 0.625V3.125C3.75 3.47047 4.02953 3.75 4.375 3.75ZM20 5V17.5C20 18.8806 18.8806 20 17.5 20H2.5C1.11937 20 0 18.8806 0 17.5V5C0 3.61937 1.11937 2.5 2.5 2.5H3.125V3.125C3.125 3.81348 3.6859 4.375 4.375 4.375H5.625C6.3141 4.375 6.875 3.81348 6.875 3.125V2.5H13.125V3.125C13.125 3.81348 13.6865 4.375 14.375 4.375H15.625C16.3135 4.375 16.875 3.81348 16.875 3.125V2.5H17.5C18.8806 2.5 20 3.61937 20 5ZM18.75 7.5C18.75 6.81152 18.1897 6.25 17.5 6.25H2.5C1.8109 6.25 1.25 6.81152 1.25 7.5V17.5C1.25 18.1897 1.8109 18.75 2.5 18.75H17.5C18.1897 18.75 18.75 18.1897 18.75 17.5V7.5ZM14.375 3.75H15.625C15.9705 3.75 16.25 3.47047 16.25 3.125V0.625C16.25 0.279531 15.9705 0 15.625 0H14.375C14.0295 0 13.75 0.279531 13.75 0.625V3.125C13.75 3.47047 14.0295 3.75 14.375 3.75Z"
                                                fill="#F96921" />
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <label class="text-secondary fs-6 fw-5 mb-1">Hour:</label>
                        <div class="mb-40">
                            <div class="row">
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100 fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100 fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100 fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-lg-0 mb-2 px-2">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100 fs-14 fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center px-sm-4 mx-sm-3 mx-2">
                            <button type="submit" class="btn btn-primary w-100">
                                Book Appointment
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="gallery-section pt-60 px-sm-4 px-3">
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Gallery</h2>
                </div>
                <div class="position-relative">
                    <div class="gallery-bg-img text-end">
                        <img src="{{ asset('assets/img/vcard23/gallery-bg.png') }}" alt="gallery-bg" />
                    </div>

                    <div class="gallery-slider">
                        <div class="slide px-sm-2 px-1">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard23/gallery-img.png') }}" />
                            </div>
                        </div>
                        <div class="slide px-sm-2 px-1">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard23/gallery-img.png') }}" />
                            </div>
                        </div>
                        <div class="slide px-sm-2 px-1">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard23/gallery-img.png') }}" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial-section pt-60 px-40">
                <div class="testimonial-bg-img">
                    <img src="{{ asset('assets/img/vcard23/testimonial-bg.png') }}" />
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Testimonial</h2>
                </div>
                <div class="testimonial-slider">
                    <div class="px-sm-4">
                        <div class="testimonial-card card">
                            <div class="testimonial-profile-img">
                                <img src="{{ asset('assets/img/vcard23/testimonial-profile-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 pt-3">
                                <div class="text-center">
                                    <h3 class="text-primary fs-20 mb-0">Ronald Richards</h3>
                                    <p class="fs-14 text-secondary">Customer</p>
                                    <p class="desc text-gray-100 fs-14">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore Lorem ipsum
                                        dolor sit amet, consectetur adipiscing elit, sed do
                                        eiusmod tempor incididunt ut laboreLorem ipsum dolor sit
                                        amet, consectetur adipiscing elit, sed
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="px-sm-4">
                        <div class="testimonial-card card">
                            <div class="testimonial-profile-img">
                                <img src="{{ asset('assets/img/vcard23/testimonial-profile-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 pt-3">
                                <div class="text-center">
                                    <h3 class="text-primary fs-20 mb-0">Ronald Richards</h3>
                                    <p class="fs-14 text-secondary">Customer</p>
                                    <p class="desc text-gray-100 fs-14">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore Lorem ipsum
                                        dolor sit amet, consectetur adipiscing elit, sed do
                                        eiusmod tempor incididunt ut laboreLorem ipsum dolor sit
                                        amet, consectetur adipiscing elit, sed
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="product-section pt-60 px-40">
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Products</h2>
                </div>
                <div class="">
                    <div class="product-slider">
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard23/product-img2.png') }}"
                                        class="w-100 h-100 object-fit-cover" />
                                </div>
                                <div
                                    class="product-desc card-body p-3 d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <h3 class="text-secondary fs-18 fw-5 mb-0">Judiciary</h3>
                                        <p class="mb-0 text-gray-100 fs-14">Lorem Ipsum</p>
                                    </div>
                                    <h4 class="text-center text-primary mb-0">$120</h4>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard23/product-img1.png') }}"
                                        class="w-100 h-100 object-fit-cover" />
                                </div>
                                <div
                                    class="product-desc card-body p-3 d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <h3 class="text-secondary fs-18 fw-5 mb-0">Judiciary</h3>
                                        <p class="mb-0 text-gray-100 fs-14">Lorem Ipsum</p>
                                    </div>
                                    <h4 class="text-center text-primary mb-0">$120</h4>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard23/product-img2.png') }}"
                                        class="w-100 h-100 object-fit-cover" />
                                </div>
                                <div
                                    class="product-desc card-body p-3 d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <h3 class="text-secondary fs-18 fw-5 mb-0">Judiciary</h3>
                                        <p class="mb-0 text-gray-100 fs-14">Lorem Ipsum</p>
                                    </div>
                                    <h4 class="text-center text-primary mb-0">$120</h4>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard23/product-img1.png') }}"
                                        class="w-100 h-100 object-fit-cover" />
                                </div>
                                <div
                                    class="product-desc card-body p-3 d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <h3 class="text-secondary fs-18 fw-5 mb-0">Judiciary</h3>
                                        <p class="mb-0 text-gray-100 fs-14">Lorem Ipsum</p>
                                    </div>
                                    <h4 class="text-center text-primary mb-0">$120</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-section pt-60">
                <div class="blog-bg text-center">
                    <img src="{{ asset('assets/img/vcard23/blog-bg.png') }}" alt="blog-bg" />
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Blog</h2>
                </div>
                <div class="blog-slider pt-sm-5">
                    <div>
                        <div class="blog-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard23/blog-img1.png') }}" class="h-100" />
                            </div>
                            <div class="card-body">
                                <h5 class="text-secondary fs-18">Loreum Ipsum</h5>
                                <p class="text-gray-100 mb-0 fs-12">
                                    Lorem Ipsum is simply dummy text of the printing and
                                    typesetting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="blog-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard23/blog-img2.png') }}" class="h-100" />
                            </div>
                            <div class="card-body">
                                <h5 class="text-secondary fs-18">Loreum Ipsum</h5>
                                <p class="text-gray-100 mb-0 fs-12">
                                    Lorem Ipsum is simply dummy text of the printing and
                                    typesetting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="blog-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard23/blog-img3.png') }}" class="h-100" />
                            </div>
                            <div class="card-body">
                                <h5 class="text-secondary fs-18">Loreum Ipsum</h5>
                                <p class="text-gray-100 mb-0 fs-12">
                                    Lorem Ipsum is simply dummy text of the printing and
                                    typesetting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="business-hour-section pt-30 px-40">
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Business Hours</h2>
                </div>
                <div class="business-hours bg-white">
                    <div class="mb-10 d-flex justify-content-between">
                        <span>Sunday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Monday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Tuesday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Wednesday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Thursday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="mb-10 d-flex justify-content-between align-items-center">
                        <span>Friday:</span>
                        <span>08:10 - 20:00</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Saturday:</span>
                        <span>Closed</span>
                    </div>
                </div>
            </div>
            <div class="qr-code-section pt-60 px-40">
                <div class="qr-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard23/qr-code-bg.png') }}" alt="qr-code-bg" />
                </div>
                <div class="section-heading mb-40 pb-40 text-center">
                    <h2 class="mb-0">QR Code</h2>
                </div>
                <div class="qr-code mx-auto position-relative">
                    <div class="qr-profile-img">
                        <img src="{{ asset('assets/img/vcard23/qr-profile-img.png') }}"
                            class="w-100 h-100 object-fit-cover" />
                    </div>
                    <div class="qr-code-img mx-auto">
                        <img src="{{ asset('assets/img/vcard23/qr-code.png') }}" class="w-100 h-100 object-fit-cover" />
                    </div>
                </div>
            </div>
            <div class="contact-us-section pt-60 px-30">
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">{{ __('messages.contact_us.inquries') }}</h2>
                </div>
                <div class="contact-form">
                    <form action="">
                        <div class="row">
                            <div class="col-12">
                                <input type="text" class="form-control" placeholder="Full Name" />
                            </div>
                            <div class="col-12">
                                <input type="email" class="form-control" placeholder="Email Address" />
                            </div>
                            <div class="col-12">
                                <input type="tel" class="form-control" placeholder="Phone Number" />
                            </div>
                            <div class="col-12 mb-40">
                                <textarea class="form-control h-100" placeholder="Your Message" rows="3"></textarea>
                            </div>
                            <div class="col-12 text-center">
                                <button class="send-btn rounded btn btn-primary" type="submit">
                                    Send Message
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="pt-40 pb-40 px-40">
                <div class="bg-img">
                    <img src="{{ asset('assets/img/vcard23/bg-img.png') }}" />
                </div>
            </div>
            <div class="create-vcard-section pt-30 pb-60 px-40">
                <div class="section-heading text-center mb-40">
                    <h2 class="mb-0">Create Your VCard</h2>
                </div>
                <div class="px-sm-3 pb-30 mb-4">
                    <div class="vcard-link-card card">
                        <div class="d-flex align-items-center justify-content-center">
                            <a href="https://vcards.infyom.com/marlonbrasil"
                                class="text-secondary link-text fw-5">https://vcards.infyom.com/marlonbrasil</a>
                            <i class="icon fa-solid fa-arrow-up-right-from-square ms-3 text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="add-to-contact-section pb-30">
                <div class="text-center">
                    <button class="add-contact-btn btn btn-primary rounded"><i
                        class="fas fa-download fa-address-book"></i>
                    &nbsp;Add to Contact</button>
                </div>
            </div>
        </div>
    </div>
</body>
@include('vcardTemplates.template.templates')
<script src="https://js.stripe.com/v3/"></script>
<script type="text/javascript" src="{{ asset('assets/js/front-third-party.js') }}"></script>
<script type="text/javascript" src="{{ asset('front/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('assets/js/slider/js/slick.min.js') }}" type="text/javascript"></script>
<script>
    $().ready(function() {
        $(".gallery-slider").slick({
            arrows: false,
            infinite: true,
            dots: true,
            slidesToShow: 1,
            autoplay: true,
        });
        $(".product-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: true,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                    dots: true,
                },
            }, ],
        });
        $(".testimonial-slider").slick({
            arrows: true,
            infinite: true,
            dots: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: true,
            prevArrow: '<button class="slide-arrow prev-arrow"><i class="fa-solid fa-arrow-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow"><i class="fa-solid fa-arrow-right"></i></button>',
            responsive: [{
                breakpoint: 575,
                settings: {
                    arrows: false,
                    dots: true,
                },
            }, ],
        });
        $(".blog-slider").slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            centerMode: true,
            arrows: false,
            dots: true,
            speed: 300,
            centerPadding: "130px",
            autoplay: false,
            responsive: [{
                    breakpoint: 768,
                    settings: {
                        centerPadding: "110px",
                    },
                },
                {
                    breakpoint: 575,
                    settings: {
                        centerPadding: "0",
                    },
                },
            ],
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('.dropdown1').hover(function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(100);
        }, function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(100);
        });
    });
</script>
</html>
