/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.js":{"Yes_Change":"\u0646\u0639\u0645\u060c \u0642\u0628\u0648\u0644","address_field":"\u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.","admin":"\u0627\u0644\u0645\u0634\u0631\u0641","agree_term":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0648\u0627\u0641\u0642 \u0639\u0644\u0649 \u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645.","allowed_file_types":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","allowed_image":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","amount":"\u0627\u0644\u0645\u0628\u0644\u063a","app_name_required":"\u062d\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0645\u0637\u0644\u0648\u0628","apply":"\u062a\u0642\u062f\u064a\u0645 \u0637\u0644\u0628","appointment":"\u0627\u0644\u0645\u0648\u0639\u062f","appointments":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","apr":"\u0625\u0628\u0631\u064a\u0644","are_you_completed":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0647\u0630\u0627\u061f","are_you_sure":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_dublicate_vcard":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062e\u0629 \u0645\u0643\u0631\u0631\u0629 \u0645\u0646 \u0647\u0630\u0647 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0634\u062e\u0635\u064a\u0629\u061f","aug":"\u0623\u063a\u0633\u0637\u0633","cancel":"\u0625\u0644\u063a\u0627\u0621","choose_one_template":"\u0627\u062e\u062a\u0631 \u0623\u064a \u0642\u0627\u0644\u0628 \u0648\u0627\u062d\u062f","choose_plan":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062e\u0637\u0629","completed":"\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621","copied_successfully":"\u062a\u0645 \u0646\u0633\u062e \u0627\u0644\u0631\u0627\u0628\u0637 \u0628\u0646\u062c\u0627\u062d.","coupon_code":"\u0631\u0645\u0648\u0632 \u0627\u0644\u0642\u0633\u0627\u0626\u0645","coupon_code_percent_validation":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0643\u0648\u0646 \u062a\u062e\u0641\u064a\u0636 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u0623\u0643\u062b\u0631 \u0645\u0646 100\u066a.","custom":"\u0645\u062e\u0635\u0635","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","delete":"\u062d\u0630\u0641","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641","description":"\u0623\u062f\u062e\u0644 \u0648\u0635\u0641 \u0628\u0637\u0627\u0642\u062a\u0643 \u0627\u0644\u0634\u062e\u0635\u064a\u0629","duplicate":"\u0645\u0643\u0631\u0631!","duplicate_vcard":"\u0628\u0637\u0627\u0642\u0629 \u0634\u062e\u0635\u064a\u0629 \u0645\u0643\u0631\u0631\u0629!","duplicate_vcard_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0629 \u0634\u062e\u0635\u064a\u0629 \u0645\u0643\u0631\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_required":"\u062d\u0642\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0637\u0644\u0648\u0628","enter_valid_email":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0635\u0627\u0644\u062d.","error":"\u062e\u0637\u0623","faqs":"\u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","first_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644 \u0645\u0637\u0644\u0648\u0628.","flat":"\u0645\u0633\u062a\u0648\u0649","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","from":"\u0645\u0646","gallery":"\u0645\u0639\u0631\u0636 \u0627\u0644\u0635\u0648\u0631","has_been_completed":"\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621.","has_been_deleted":"\u062a\u0645 \u062d\u0630\u0641\u0647.","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","last_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631 \u0645\u0637\u0644\u0648\u0628.","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","loading":"\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u0645\u064a\u0644...","manual_payment_guide":"\u062f\u0644\u064a\u0644 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","mar":"\u0645\u0627\u0631\u0633","may":"\u0645\u0627\u064a\u0648","mon":"\u0627\u0644\u0627\u062b\u0646\u064a\u0646","month":"\u0627\u0644\u0634\u0647\u0631","multi_templates":"\u0645\u0637\u0644\u0648\u0628 \u0642\u0648\u0627\u0644\u0628 \u0645\u062a\u0639\u062f\u062f\u0629","no":"\u0644\u0627","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","ok":"\u062d\u0633\u0646\u0627","password_character":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 8 \u0623\u062d","password_must_match":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0637\u0627\u0628\u0642 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0639 \u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631.","passwords":"\u062d\u0642\u0644 \u0643\u0644\u0645\u0627\u062a \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0637\u0644\u0648\u0628.","payment_not_complete":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621 \u0645\u0646 \u0639\u0645\u0644\u064a\u0629 \u0627\u0644\u062f\u0641\u0639","paypal_mode":"\u062d\u0642\u0644 \u0648\u0636\u0639 Paypal \u0645\u0637\u0644\u0648\u0628.","paypal_secret":"\u062d\u0642\u0644 \u0633\u0631 Paypal \u0645\u0637\u0644\u0648\u0628.","paystack_key":"\u0645\u0641\u062a\u0627\u062d \u0628\u0627\u064a\u0633\u062a\u0627\u0643","paystack_secret":"\u0633\u0631 \u0628\u0627\u064a\u0633\u062a\u0627\u0643","phone":"\u0627\u0644\u0647\u0627\u062a\u0641","phone_number_required":"\u062d\u0642\u0644 \u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641 \u0645\u0637\u0644\u0648\u0628.","plan_expire_notification":"\u062d\u0642\u0644 \u0625\u0634\u0639\u0627\u0631 \u0627\u0646\u062a\u0647\u0627\u0621 \u0627\u0644\u062e\u0637\u0629 \u0645\u0637\u0644\u0648\u0628.","privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","purchase":"\u0634\u0631\u0627\u0621","remove":"\u0625\u0632\u0627\u0644\u0629","sat":"\u0627\u0644\u0633\u0628\u062a","select_hour":"\u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0623\u0648 \u0627\u0644\u0633\u0627\u0639\u0629","select_one_or_more":"\u062d\u062f\u062f \u0648\u0627\u062d\u062f \u0623\u0648 \u0623\u0643\u062b\u0631","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","social_links_img_is_required":"\u0635\u0648\u0631\u0629 \u0631\u0648\u0627\u0628\u0637 \u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u062a\u0648\u0627\u0635\u0644 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a \u0645\u0637\u0644\u0648\u0628\u0629.","social_links_is_required":"\u0631\u0648\u0627\u0628\u0637 \u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u062a\u0648\u0627\u0635\u0644 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a \u0645\u0637\u0644\u0648\u0628\u0629.","stripe_secret":"\u062d\u0642\u0644 \u0633\u0631 Stripe \u0645\u0637\u0644\u0648\u0628.","subscriptions":"\u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643\u0627\u062a","successful":"\u0646\u0627\u062c\u062d","sun":"\u0627\u0644\u0623\u062d\u062f","term_condition":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645","testimonial":"\u0634\u0647\u0627\u062f\u0629","the_term_conditions":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629.","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0623\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","to":"\u0625\u0644\u0649","today":"\u0627\u0644\u064a\u0648\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","unavailable":"\u063a\u064a\u0631 \u0645\u062a\u0627\u062d","upload_required":"\u062d\u0642\u0644 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u0645\u0637\u0644\u0648\u0628.","user":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","vcard_name":"\u0627\u0633\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0634\u062e\u0635\u064a\u0629","wed":"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621","yes":"\u0646\u0639\u0645"},"de.js":{"Yes_Change":"Ja, Genehmigen","address_field":"Das Feld Adresse ist erforderlich.","admin":"Administrator","agree_term":"Sie m\u00fcssen den Nutzungsbedingungen zustimmen.","allowed_file_types":"Erlaubte Dateitypen: png, jpg, jpeg.","allowed_image":"Erlaubte Dateitypen: png, jpg, jpeg.","amount":"Betrag","app_name_required":"Das App-Namen-Feld ist erforderlich","apply":"Anwenden","appointment":"Termin","appointments":"Termine","apr":"Apr","are_you_completed":"Sind Sie sicher, dass Sie dies genehmigen m\u00f6chten?","are_you_sure":"Sind Sie sicher, dass Sie dies l\u00f6schen m\u00f6chten","are_you_sure_dublicate_vcard":"Sind Sie sicher, dass Sie diese VCard duplizieren m\u00f6chten?","aug":"Aug","cancel":"Abbrechen","choose_one_template":"W\u00e4hlen Sie eine Vorlage aus","choose_plan":"Plan ausw\u00e4hlen","completed":"Abgeschlossen","copied_successfully":"Link erfolgreich kopiert.","coupon_code":"Gutscheincode","coupon_code_percent_validation":"Der Rabattcode darf nicht mehr als 100% betragen.","custom":"Benutzerdefiniert","dec":"Dez","delete":"L\u00f6schen","deleted":"Gel\u00f6scht","description":"Beschreibung Ihrer VCard eingeben","duplicate":"Duplikat!","duplicate_vcard":"Duplizierte VCard!","duplicate_vcard_create":"Duplizierte VCard erfolgreich erstellt","email":"E-Mail","email_required":"Das E-Mail-Feld ist erforderlich","enter_valid_email":"Bitte geben Sie eine g\u00fcltige E-Mail-Adresse ein.","error":"Fehler","faqs":"FAQs","feb":"Feb","first_name_required":"Das Feld Vorname ist erforderlich.","flat":"Flach","fri":"Fr","from":"Von","gallery":"Galerie","has_been_completed":"wurde abgeschlossen.","has_been_deleted":"wurde gel\u00f6scht.","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_number":"Ung\u00fcltige Nummer","jan":"Jan","jul":"Jul","jun":"Jun","last_name_required":"Das Feld Nachname ist erforderlich.","last_week":"Letzte Woche","loading":"Laden...","manual_payment_guide":"Anleitung zur manuellen Zahlung","mar":"M\u00e4r","may":"Mai","mon":"Mo","month":"Monat","multi_templates":"Mehrere Vorlagen sind erforderlich","no":"Nein","nov":"Nov","oct":"Okt","ok":"OK","password_character":"Das Passwort muss mindestens 8 Zeichen lang sein.","password_must_match":"Das Passwort und die Passwortbest\u00e4tigung m\u00fcssen \u00fcbereinstimmen.","passwords":"Das Passwortfeld ist erforderlich.","payment_not_complete":"Zahlung nicht abgeschlossen","paypal_mode":"Das Feld PayPal-Modus ist erforderlich.","paypal_secret":"Das Feld PayPal Secret ist erforderlich.","paystack_key":"Paystack Schl\u00fcssel","paystack_secret":"Paystack Geheimnis","phone":"Telefon","phone_number_required":"Das Feld Telefonnummer ist erforderlich.","plan_expire_notification":"Das Feld f\u00fcr die Benachrichtigung \u00fcber das Ablaufen des Plans ist erforderlich.","privacy_policy":"Datenschutzrichtlinie","purchase":"Kauf","remove":"Entfernen","sat":"Sa","select_hour":"Bitte w\u00e4hlen Sie Datum oder Stunde","select_one_or_more":"W\u00e4hlen Sie eine oder mehrere Funktionen aus","sep":"Sep","social_links_img_is_required":"Soziale Links Bild ist erforderlich.","social_links_is_required":"Soziale Links sind erforderlich.","stripe_secret":"Das Feld Stripe Secret ist erforderlich.","subscriptions":"Abonnements","successful":"Erfolgreich","sun":"So","term_condition":"Nutzungsbedingungen","testimonial":"Referenz","the_term_conditions":"Die Nutzungsbedingungen sind erforderlich.","this_week":"Diese Woche","thu":"Do","to":"Bis","today":"Heute","too_long":"Zu lang","too_short":"Zu kurz","tue":"Di","unavailable":"Nicht verf\u00fcgbar","upload_required":"Das Feld f\u00fcr den Dateiupload ist erforderlich.","user":"Benutzer","vcard_name":"VCard-Name","wed":"Mi","yes":"Ja"},"en.js":{"Yes_Change":"Yes, Approve","address_field":"Address Field field is required.","admin":"Admin","agree_term":"You must agreed to Terms and conditions.","allowed_file_types":"Allowed file types: png, jpg, jpeg.","allowed_image":"Allowed file types: png, jpg, jpeg.","amount":"Amount","app_name_required":"App Name field is required","apply":"Apply","appointment":"Appointment","appointments":"Appointments","apr":"Apr","are_you_completed":"Are you sure, you want to approve this ?","are_you_sure":"Are you sure want to delete this","are_you_sure_dublicate_vcard":"Are you sure want to create duplicate  this VCard ?","aug":"Aug","cancel":"Cancel","choose_one_template":"Choose any one template","choose_plan":"Choose Plan","completed":"Completed","copied_successfully":"Link copied successfully.","coupon_code":"Coupon Codes","coupon_code_percent_validation":"Coupon discount should not be more than 100%.","custom":"Custom","dec":"Dec","delete":"Delete","deleted":"Deleted","description":"Enter Description of Your VCard","duplicate":"Duplicate !","duplicate_vcard":"Duplicate Vcard !","duplicate_vcard_create":"Duplicate Vcard created successfully","email":"Email","email_required":"Email field is required","enter_valid_email":"Please enter valid Email.","error":"Error","faqs":"FAQs","feb":"Feb","first_name_required":"First Name field is required.","flat":"Flat","fri":"FRI","from":"From","gallery":"Gallery","has_been_completed":"has been completed.","has_been_deleted":"has been deleted.","invalid_country_code":"Invalid country code","invalid_number":"Invalid Number","jan":"Jan","jul":"Jul","jun":"Jun","last_name_required":"Last Name field is required.","last_week":"Last Week","loading":"Loading...","manual_payment_guide":"Manual Payment Guide","mar":"Mar","may":"May","mon":"MON","month":"Month","multi_templates":"Multi templates is required","no":"No","nov":"Nov","oct":"Oct","ok":"Ok","password_character":"The password must be at least 8 characters.","password_must_match":"The password and password confirmation must match.","passwords":"The passwords field is required.","payment_not_complete":"Payment Not Completed","paypal_mode":"Paypal mode field is required.","paypal_secret":"Paypal secret field is required.","paystack_key":"Paystack key","paystack_secret":"Paystack Secret","phone":"Phone","phone_number_required":"Phone Number field is required.","plan_expire_notification":"Plan Expire Notification field is required.","privacy_policy":"Privacy Policy","purchase":"Purchase","remove":"Remove","sat":"SAT","select_hour":"Please Select Date Or Hour","select_one_or_more":"Select one or more Feature is required","sep":"Sep","social_links_img_is_required":"Social links Image is required.","social_links_is_required":"Social links is required.","stripe_secret":"Stripe secret field is required.","subscriptions":"Subscriptions","successful":"Successful","sun":"SUN","term_condition":"Terms & Conditions","testimonial":"Testimonial","the_term_conditions":"The Terms & Conditions is required.","this_week":"This Week","thu":"THU","to":"To","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","unavailable":"Unavailable","upload_required":"The file upload field is required.","user":"User","vcard_name":"VCard Name","wed":"WED","yes":"Yes"},"es.js":{"Yes_Change":"S\u00ed, Aprobar","address_field":"El campo de direcci\u00f3n es obligatorio.","admin":"Administrador","agree_term":"Debes estar de acuerdo con los t\u00e9rminos y condiciones.","allowed_file_types":"Tipos de archivo permitidos: png, jpg, jpeg.","allowed_image":"Tipos de archivo permitidos: png, jpg, jpeg.","amount":"Cantidad","app_name_required":"El campo de nombre de la aplicaci\u00f3n es obligatorio","apply":"Aplicar","appointment":"Cita","appointments":"Citas","apr":"Abr","are_you_completed":"\u00bfEst\u00e1s seguro de que deseas aprobar esto?","are_you_sure":"\u00bfEst\u00e1s seguro de que quieres eliminar esto?","are_you_sure_dublicate_vcard":"\u00bfEst\u00e1s seguro de que quieres duplicar esta VCard?","aug":"Ago","cancel":"Cancelar","choose_one_template":"Elige una plantilla","choose_plan":"Selecciona un plan","completed":"Completado","copied_successfully":"Enlace copiado exitosamente.","coupon_code":"C\u00f3digos de cup\u00f3n","coupon_code_percent_validation":"El descuento del cup\u00f3n no debe ser superior al 100%.","custom":"Personalizado","dec":"Dic","delete":"Eliminar","deleted":"Eliminado","description":"Ingresa la descripci\u00f3n de tu VCard","duplicate":"Duplicado","duplicate_vcard":"VCard duplicada","duplicate_vcard_create":"VCard duplicada creada exitosamente","email":"Correo electr\u00f3nico","email_required":"El campo de correo electr\u00f3nico es obligatorio","enter_valid_email":"Por favor, ingresa un correo electr\u00f3nico v\u00e1lido.","error":"Error","faqs":"Preguntas frecuentes","feb":"Feb","first_name_required":"El campo de nombre es obligatorio.","flat":"Plano","fri":"VIE","from":"Desde","gallery":"Galer\u00eda","has_been_completed":"ha sido completado.","has_been_deleted":"ha sido eliminado.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero no v\u00e1lido","jan":"Ene","jul":"Jul","jun":"Jun","last_name_required":"El campo de apellido es obligatorio.","last_week":"Semana pasada","loading":"Cargando...","manual_payment_guide":"Gu\u00eda de pago manual","mar":"Mar","may":"May","mon":"LUN","month":"Mes","multi_templates":"Se requieren varias plantillas","no":"No","nov":"Nov","oct":"Oct","ok":"Aceptar","password_character":"La contrase\u00f1a debe tener al menos 8 caracteres.","password_must_match":"La contrase\u00f1a y la confirmaci\u00f3n de la contrase\u00f1a deben coincidir.","passwords":"El campo de contrase\u00f1as es obligatorio.","payment_not_complete":"Pago no completado","paypal_mode":"El campo de modo de PayPal es obligatorio.","paypal_secret":"El campo de secreto de PayPal es obligatorio.","paystack_key":"Clave Paystack","paystack_secret":"Secreto Paystack","phone":"Tel\u00e9fono","phone_number_required":"El campo de n\u00famero de tel\u00e9fono es obligatorio.","plan_expire_notification":"El campo de notificaci\u00f3n de vencimiento del plan es obligatorio.","privacy_policy":"Pol\u00edtica de privacidad","purchase":"Compra","remove":"Eliminar","sat":"SAB","select_hour":"Por favor, selecciona fecha u hora","select_one_or_more":"Selecciona una o m\u00e1s funciones requeridas","sep":"Sep","social_links_img_is_required":"Se requiere la imagen de enlaces sociales.","social_links_is_required":"Se requieren enlaces sociales.","stripe_secret":"El campo de secreto de Stripe es obligatorio.","subscriptions":"Suscripciones","successful":"Exitoso","sun":"DOM","term_condition":"T\u00e9rminos y condiciones","testimonial":"Testimonio","the_term_conditions":"Se requieren los t\u00e9rminos y condiciones.","this_week":"Esta semana","thu":"JUE","to":"Hasta","today":"Hoy","too_long":"Demasiado largo","too_short":"Demasiado corto","tue":"MAR","unavailable":"No disponible","upload_required":"El campo de carga de archivos es obligatorio.","user":"Usuario","vcard_name":"Nombre de la VCard","wed":"MIE","yes":"S\u00ed"},"fr.js":{"Yes_Change":"Oui, Approuver","address_field":"Le champ Adresse est requis.","admin":"Admin","agree_term":"Vous devez accepter les termes et conditions.","allowed_file_types":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","allowed_image":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","amount":"Montant","app_name_required":"Le champ Nom de l'application est requis","apply":"Appliquer","appointment":"Rendez-vous","appointments":"Rendez-vous","apr":"Avr","are_you_completed":"\u00cates-vous s\u00fbr de vouloir approuver ceci ?","are_you_sure":"\u00cates-vous s\u00fbr de vouloir supprimer ceci","are_you_sure_dublicate_vcard":"\u00cates-vous s\u00fbr de vouloir cr\u00e9er une copie de cette VCard ?","aug":"Ao\u00fbt","cancel":"Annuler","choose_one_template":"Choisissez un mod\u00e8le","choose_plan":"Choisissez un plan","completed":"Termin\u00e9","copied_successfully":"Lien copi\u00e9 avec succ\u00e8s.","coupon_code":"Codes de coupon","coupon_code_percent_validation":"La r\u00e9duction du coupon ne doit pas \u00eatre sup\u00e9rieure \u00e0 100%.","custom":"Personnalis\u00e9","dec":"D\u00e9c","delete":"Supprimer","deleted":"Supprim\u00e9","description":"Entrez la description de votre VCard","duplicate":"Dupliqu\u00e9 !","duplicate_vcard":"VCard dupliqu\u00e9e !","duplicate_vcard_create":"VCard dupliqu\u00e9e cr\u00e9\u00e9e avec succ\u00e8s","email":"E-mail","email_required":"Le champ email est obligatoire","enter_valid_email":"Veuillez entrer une adresse e-mail valide.","error":"Erreur","faqs":"FAQs","feb":"F\u00e9v","first_name_required":"Le champ Pr\u00e9nom est requis.","flat":"\u00c0 plat","fri":"VEN","from":"De","gallery":"Galerie","has_been_completed":"a \u00e9t\u00e9 termin\u00e9.","has_been_deleted":"a \u00e9t\u00e9 supprim\u00e9.","invalid_country_code":"Code pays invalide","invalid_number":"Num\u00e9ro invalide","jan":"Jan","jul":"Juil","jun":"Juin","last_name_required":"Le champ Nom de famille est requis.","last_week":"La semaine derni\u00e8re","loading":"Chargement...","manual_payment_guide":"Guide de paiement manuel","mar":"Mar","may":"Mai","mon":"LUN","month":"Mois","multi_templates":"Plusieurs mod\u00e8les sont requis","no":"Non","nov":"Nov","oct":"Oct","ok":"OK","password_character":"Le mot de passe doit comporter au moins 8 caract\u00e8res.","password_must_match":"Le mot de passe et la confirmation du mot de passe doivent correspondre.","passwords":"Le champ Mots de passe est requis.","payment_not_complete":"Paiement non termin\u00e9","paypal_mode":"Le champ Mode PayPal est requis.","paypal_secret":"Le champ Secret PayPal est requis.","paystack_key":"Cl\u00e9 Paystack","paystack_secret":"Secret Paystack","phone":"T\u00e9l\u00e9phone","phone_number_required":"Le champ Num\u00e9ro de t\u00e9l\u00e9phone est requis.","plan_expire_notification":"Le champ Notification d'expiration du plan est requis.","privacy_policy":"Politique de confidentialit\u00e9","purchase":"Achat","remove":"Supprimer","sat":"SAM","select_hour":"Veuillez s\u00e9lectionner la date ou l'heure","select_one_or_more":"S\u00e9lectionnez une ou plusieurs fonctionnalit\u00e9s requises","sep":"Sep","social_links_img_is_required":"L'image des liens sociaux est requise.","social_links_is_required":"Les liens sociaux sont requis.","stripe_secret":"Le champ Secret Stripe est requis.","subscriptions":"Abonnements","successful":"R\u00e9ussi","sun":"DIM","term_condition":"Conditions g\u00e9n\u00e9rales","testimonial":"T\u00e9moignage","the_term_conditions":"Les conditions g\u00e9n\u00e9rales sont requises.","this_week":"Cette semaine","thu":"JEU","to":"\u00c0","today":"Aujourd'hui","too_long":"Trop long","too_short":"Trop court","tue":"MAR","unavailable":"Indisponible","upload_required":"Le champ de t\u00e9l\u00e9chargement de fichier est requis.","user":"Utilisateur","vcard_name":"Nom de la VCard","wed":"MER","yes":"Oui"},"pt.js":{"Yes_Change":"Sim, Aprovar","address_field":"O campo de Endere\u00e7o \u00e9 obrigat\u00f3rio.","admin":"Admin","agree_term":"Voc\u00ea deve concordar com os Termos e Condi\u00e7\u00f5es.","allowed_file_types":"Tipos de arquivo permitidos: png, jpg, jpeg.","allowed_image":"Tipos de arquivo permitidos: png, jpg, jpeg.","amount":"Quantidade","app_name_required":"O campo Nome do Aplicativo \u00e9 obrigat\u00f3rio","apply":"Aplicar","appointment":"Compromisso","appointments":"Compromissos","apr":"Abr","are_you_completed":"Voc\u00ea tem certeza de que deseja aprovar isso?","are_you_sure":"Tem certeza de que deseja excluir isso","are_you_sure_dublicate_vcard":"Tem certeza de que deseja criar uma duplicata deste VCard?","aug":"Ago","cancel":"Cancelar","choose_one_template":"Escolha qualquer modelo","choose_plan":"Escolha o Plano","completed":"Conclu\u00eddo","copied_successfully":"Link copiado com sucesso.","coupon_code":"C\u00f3digos de Cupom","coupon_code_percent_validation":"O desconto do cupom n\u00e3o deve ser superior a 100%.","custom":"Personalizado","dec":"Dez","delete":"Excluir","deleted":"Exclu\u00eddo","description":"Insira a descri\u00e7\u00e3o do seu VCard","duplicate":"Duplicar!","duplicate_vcard":"Vcard Duplicado!","duplicate_vcard_create":"Vcard duplicado criado com sucesso","email":"E-mail","email_required":"O campo e-mail \u00e9 obrigat\u00f3rio","enter_valid_email":"Por favor, insira um e-mail v\u00e1lido.","error":"Erro","faqs":"FAQs","feb":"Fev","first_name_required":"O campo Nome \u00e9 obrigat\u00f3rio.","flat":"Fixo","fri":"SEX","from":"De","gallery":"Galeria","has_been_completed":"foi conclu\u00eddo.","has_been_deleted":"foi exclu\u00eddo.","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","jan":"Jan","jul":"Jul","jun":"Jun","last_name_required":"O campo Sobrenome \u00e9 obrigat\u00f3rio.","last_week":"Semana Passada","loading":"Carregando...","manual_payment_guide":"Guia de Pagamento Manual","mar":"Mar","may":"Mai","mon":"SEG","month":"M\u00eas","multi_templates":"M\u00faltiplos modelos s\u00e3o necess\u00e1rios","no":"N\u00e3o","nov":"Nov","oct":"Out","ok":"Ok","password_character":"A senha deve ter pelo menos 8 caracteres.","password_must_match":"A senha e a confirma\u00e7\u00e3o da senha devem ser iguais.","passwords":"O campo Senhas \u00e9 obrigat\u00f3rio.","payment_not_complete":"Pagamento n\u00e3o conclu\u00eddo","paypal_mode":"O campo Modo do Paypal \u00e9 obrigat\u00f3rio.","paypal_secret":"O campo Segredo do Paypal \u00e9 obrigat\u00f3rio.","paystack_key":"Chave Paystack","paystack_secret":"Segredo Paystack","phone":"Telefone","phone_number_required":"O campo N\u00famero de Telefone \u00e9 obrigat\u00f3rio.","plan_expire_notification":"O campo de Notifica\u00e7\u00e3o de Expira\u00e7\u00e3o do Plano \u00e9 obrigat\u00f3rio.","privacy_policy":"Pol\u00edtica de Privacidade","purchase":"Compra","remove":"Remover","sat":"S\u00c1B","select_hour":"Por favor, selecione Data ou Hora","select_one_or_more":"Selecione uma ou mais caracter\u00edsticas s\u00e3o necess\u00e1rias","sep":"Set","social_links_img_is_required":"A imagem dos links sociais \u00e9 obrigat\u00f3ria.","social_links_is_required":"Links sociais s\u00e3o obrigat\u00f3rios.","stripe_secret":"O campo Segredo do Stripe \u00e9 obrigat\u00f3rio.","subscriptions":"Assinaturas","successful":"Bem-sucedido","sun":"DOM","term_condition":"Termos e Condi\u00e7\u00f5es","testimonial":"Depoimento","the_term_conditions":"Os Termos e Condi\u00e7\u00f5es s\u00e3o obrigat\u00f3rios.","this_week":"Esta Semana","thu":"QUI","to":"Para","today":"Hoje","too_long":"Muito longo","too_short":"Muito curto","tue":"TER","unavailable":"Indispon\u00edvel","upload_required":"O campo de upload de arquivo \u00e9 obrigat\u00f3rio.","user":"Usu\u00e1rio","vcard_name":"Nome do VCard","wed":"QUA","yes":"Sim"},"ru.js":{"Yes_Change":"\u0414\u0430, \u041e\u0434\u043e\u0431\u0440\u0438\u0442\u044c","address_field":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0435 \"\u0410\u0434\u0440\u0435\u0441\".","admin":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440","agree_term":"\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0433\u043b\u0430\u0441\u0438\u0442\u044c\u0441\u044f \u0441 \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u043c\u0438.","allowed_file_types":"\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","allowed_image":"\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","amount":"\u0421\u0443\u043c\u043c\u0430","app_name_required":"\u041f\u043e\u043b\u0435 \"\u0418\u043c\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f","apply":"\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c","appointment":"\u0417\u0430\u043f\u0438\u0441\u044c","appointments":"\u0417\u0430\u043f\u0438\u0441\u0438","apr":"\u0410\u043f\u0440","are_you_completed":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0434\u043e\u0431\u0440\u0438\u0442\u044c \u044d\u0442\u043e?","are_you_sure":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e","are_you_sure_dublicate_vcard":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u044d\u0442\u043e\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438?","aug":"\u0410\u0432\u0433","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","choose_one_template":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u044e\u0431\u043e\u0439 \u0448\u0430\u0431\u043b\u043e\u043d","choose_plan":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d","completed":"\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e","copied_successfully":"\u0421\u0441\u044b\u043b\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0430.","coupon_code":"\u041f\u0440\u043e\u043c\u043e\u043a\u043e\u0434\u044b","coupon_code_percent_validation":"\u0421\u043a\u0438\u0434\u043a\u0430 \u043f\u043e \u043a\u0443\u043f\u043e\u043d\u0443 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u0435\u0435 100%.","custom":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439","dec":"\u0414\u0435\u043a","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e","description":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0430\u0448\u0435\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","duplicate":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442!","duplicate_vcard":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0432","duplicate_vcard_create":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","email_required":"\u041f\u043e\u043b\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","enter_valid_email":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b.","error":"\u041e\u0448\u0438\u0431\u043a\u0430","faqs":"\u0427\u0430\u0441\u0442\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b","feb":"\u0424\u0435\u0432","first_name_required":"\u041f\u043e\u043b\u0435 \"\u0418\u043c\u044f\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","flat":"\u041f\u043b\u043e\u0441\u043a\u0438\u0439","fri":"\u041f\u0422","from":"\u041e\u0442","gallery":"\u0413\u0430\u043b\u0435\u0440\u0435\u044f","has_been_completed":"\u0431\u044b\u043b\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430.","has_been_deleted":"\u0431\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.","invalid_country_code":"\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","jan":"\u042f\u043d\u0432","jul":"\u0418\u044e\u043b","jun":"\u0418\u044e\u043d","last_name_required":"\u041f\u043e\u043b\u0435 \"\u0424\u0430\u043c\u0438\u043b\u0438\u044f\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","last_week":"\u041d\u0430 \u043f\u0440\u043e\u0448\u043b\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","loading":"\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...","manual_payment_guide":"\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e \u0440\u0443\u0447\u043d\u043e\u0439 \u043e\u043f\u043b\u0430\u0442\u0435","mar":"\u041c\u0430\u0440","may":"\u041c\u0430\u0439","mon":"\u041f\u041d","month":"\u041c\u0435\u0441\u044f\u0446","multi_templates":"\u0422\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432","no":"\u041d\u0435\u0442","nov":"\u041d\u043e\u044f","oct":"\u041e\u043a\u0442","ok":"\u041e\u043a","password_character":"\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 8 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.","password_must_match":"\u041f\u0430\u0440\u043e\u043b\u044c \u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c.","passwords":"\u041f\u043e\u043b\u0435 \"\u041f\u0430\u0440\u043e\u043b\u0438\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","payment_not_complete":"\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430","paypal_mode":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0440\u0435\u0436\u0438\u043c PayPal.","paypal_secret":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 PayPal.","paystack_key":"\u041a\u043b\u044e\u0447 Paystack","paystack_secret":"\u0421\u0435\u043a\u0440\u0435\u0442 Paystack","phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d","phone_number_required":"\u041f\u043e\u043b\u0435 \"\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","plan_expire_notification":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438 \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043b\u0430\u043d\u0430.","privacy_policy":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","purchase":"\u041f\u043e\u043a\u0443\u043f\u043a\u0430","remove":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","sat":"\u0421\u0411","select_hour":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0438\u043b\u0438 \u0447\u0430\u0441","select_one_or_more":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0443\u043d\u043a\u0446\u0438\u0439","sep":"\u0421\u0435\u043d","social_links_img_is_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0441\u044b\u043b\u043e\u043a.","social_links_is_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438.","stripe_secret":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 Stripe.","subscriptions":"\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438","successful":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e","sun":"\u0412\u0421","term_condition":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f","testimonial":"\u041e\u0442\u0437\u044b\u0432","the_term_conditions":"\u0422\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f.","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","thu":"\u0427\u0422","to":"\u0414\u043e","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043b\u0438\u043d\u043d\u043e\u0435","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435","tue":"\u0412\u0422","unavailable":"\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e","upload_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430.","user":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c","vcard_name":"\u0418\u043c\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","wed":"\u0421\u0420","yes":"\u0414\u0430"},"tr.js":{"Yes_Change":"Evet, Onayla","address_field":"Adres Alan\u0131 alan\u0131 gereklidir.","admin":"Y\u00f6netici","agree_term":"\u015eartlar ve ko\u015fullar\u0131 kabul etmelisiniz.","allowed_file_types":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","allowed_image":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","amount":"Tutar","app_name_required":"Uygulama Ad\u0131 alan\u0131 gereklidir","apply":"Uygula","appointment":"Randevu","appointments":"Randevular","apr":"Nis","are_you_completed":"Emin misiniz, bunu onaylamak istiyor musunuz?","are_you_sure":"Bunu silmek istedi\u011finizden emin misiniz","are_you_sure_dublicate_vcard":"Bu VCard'\u0131 \u00e7o\u011faltmak istedi\u011finizden emin misiniz?","aug":"A\u011fu","cancel":"\u0130ptal","choose_one_template":"Herhangi bir \u015fablonu se\u00e7in","choose_plan":"Plan Se\u00e7","completed":"Tamamland\u0131","copied_successfully":"Ba\u011flant\u0131 ba\u015far\u0131yla kopyaland\u0131.","coupon_code":"Kupon Kodlar\u0131","coupon_code_percent_validation":"Kupon indirimi %100'den fazla olmamal\u0131d\u0131r.","custom":"\u00d6zel","dec":"Ara","delete":"Sil","deleted":"Silindi","description":"VCard'\u0131n\u0131z\u0131n A\u00e7\u0131klamas\u0131n\u0131 Girin","duplicate":"\u00c7o\u011falt\u0131ld\u0131 !","duplicate_vcard":"\u00c7o\u011falt\u0131lan Vcard !","duplicate_vcard_create":"\u00c7o\u011falt\u0131lan Vcard ba\u015far\u0131yla olu\u015fturuldu","email":"E-posta","email_required":"E-posta alan\u0131 gereklidir","enter_valid_email":"L\u00fctfen ge\u00e7erli bir e-posta adresi girin.","error":"Hata","faqs":"SSS","feb":"\u015eub","first_name_required":"Ad alan\u0131 gereklidir.","flat":"D\u00fcz","fri":"CUM","from":"Kimden","gallery":"Galeri","has_been_completed":"tamamland\u0131.","has_been_deleted":"silindi.","invalid_country_code":"Ge\u00e7ersiz \u00fclke kodu","invalid_number":"Ge\u00e7ersiz Numara","jan":"Oca","jul":"Tem","jun":"Haz","last_name_required":"Soyad\u0131 alan\u0131 gereklidir.","last_week":"Ge\u00e7en Hafta","loading":"Y\u00fckleniyor...","manual_payment_guide":"Manuel \u00d6deme Rehberi","mar":"Mar","may":"May","mon":"PZT","month":"Ay","multi_templates":"\u00c7oklu \u015fablonlar gereklidir","no":"Hay\u0131r","nov":"Kas","oct":"Eki","ok":"Tamam","password_character":"\u015eifre en az 8 karakter olmal\u0131d\u0131r.","password_must_match":"\u015eifre ve \u015fifre onay\u0131 e\u015fle\u015fmelidir.","passwords":"\u015eifreler alan\u0131 gereklidir.","payment_not_complete":"\u00d6deme Tamamlanmad\u0131","paypal_mode":"Paypal modu alan\u0131 gereklidir.","paypal_secret":"Paypal gizli alan\u0131 gereklidir.","paystack_key":"Paystack Anahtar\u0131","paystack_secret":"Paystack Gizli","phone":"Telefon","phone_number_required":"Telefon Numaras\u0131 alan\u0131 gereklidir.","plan_expire_notification":"Plan Son Tarihi Bildirimi alan\u0131 gereklidir.","privacy_policy":"Gizlilik Politikas\u0131","purchase":"Sat\u0131n Alma","remove":"Kald\u0131r","sat":"CMT","select_hour":"L\u00fctfen Tarih veya Saat Se\u00e7in","select_one_or_more":"Bir veya daha fazla \u00f6zellik se\u00e7mek zorunludur","sep":"Eyl","social_links_img_is_required":"Sosyal ba\u011flant\u0131lar \u0130mgesi gereklidir.","social_links_is_required":"Sosyal ba\u011flant\u0131lar gereklidir.","stripe_secret":"Stripe gizli alan\u0131 gereklidir.","subscriptions":"Abonelikler","successful":"Ba\u015far\u0131l\u0131","sun":"PAZ","term_condition":"Kullan\u0131m \u015eartlar\u0131","testimonial":"Referans","the_term_conditions":"Kullan\u0131m \u015eartlar\u0131 zorunludur.","this_week":"Bu Hafta","thu":"PER","to":"Kime","today":"Bug\u00fcn","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","tue":"SAL","unavailable":"Kullan\u0131lam\u0131yor","upload_required":"Dosya y\u00fckleme alan\u0131 gereklidir.","user":"Kullan\u0131c\u0131","vcard_name":"VCard Ad\u0131","wed":"\u00c7AR","yes":"Evet"},"zh.js":{"Yes_Change":"\u662f\u7684\uff0c\u6279\u51c6","address_field":"\u5730\u5740\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","admin":"\u7ba1\u7406\u5458","agree_term":"\u60a8\u5fc5\u987b\u540c\u610f\u6761\u6b3e\u548c\u6761\u4ef6\u3002","allowed_file_types":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\uff0cjpg\uff0cjpeg\u3002","allowed_image":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\uff0cjpg\uff0cjpeg\u3002","amount":"\u6570\u91cf","app_name_required":"\u5e94\u7528\u7a0b\u5e8f\u540d\u79f0\u5b57\u6bb5\u662f\u5fc5\u9700\u7684","apply":"\u5e94\u7528","appointment":"\u7ea6\u4f1a","appointments":"\u7ea6\u4f1a","apr":"\u56db\u6708","are_you_completed":"\u60a8\u786e\u5b9a\u8981\u6279\u51c6\u5417\uff1f","are_you_sure":"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u5417","are_you_sure_dublicate_vcard":"\u60a8\u786e\u5b9a\u8981\u521b\u5efa\u6b64VCard\u7684\u526f\u672c\u5417\uff1f","aug":"\u516b\u6708","cancel":"\u53d6\u6d88","choose_one_template":"\u9009\u62e9\u4efb\u4f55\u4e00\u4e2a\u6a21\u677f","choose_plan":"\u9009\u62e9\u8ba1\u5212","completed":"\u5df2\u5b8c\u6210","copied_successfully":"\u94fe\u63a5\u5df2\u6210\u529f\u590d\u5236\u3002","coupon_code":"\u4f18\u60e0\u5238\u4ee3\u7801","coupon_code_percent_validation":"\u4f18\u60e0\u5238\u6298\u6263\u4e0d\u5f97\u8d85\u8fc7100\uff05\u3002","custom":"\u81ea\u5b9a\u4e49","dec":"\u5341\u4e8c\u6708","delete":"\u5220\u9664","deleted":"\u5df2\u5220\u9664","description":"\u8f93\u5165\u60a8\u7684VCard\u63cf\u8ff0","duplicate":"\u91cd\u590d\uff01","duplicate_vcard":"\u91cd\u590dVCard\uff01","duplicate_vcard_create":"\u6210\u529f\u521b\u5efa\u91cd\u590dVCard","email":"\u7535\u5b50\u90ae\u4ef6","email_required":"\u7535\u5b50\u90ae\u4ef6\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","enter_valid_email":"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u7535\u5b50\u90ae\u4ef6\u3002","error":"\u9519\u8bef","faqs":"\u5e38\u89c1\u95ee\u9898","feb":"\u4e8c\u6708","first_name_required":"\u540d\u5b57\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","flat":"\u5e73","fri":"\u661f\u671f\u4e94","from":"\u4ece","gallery":"\u753b\u5eca","has_been_completed":"\u5df2\u5b8c\u6210\u3002","has_been_deleted":"\u5df2\u88ab\u5220\u9664\u3002","invalid_country_code":"\u65e0\u6548\u7684\u56fd\u5bb6\u4ee3\u7801","invalid_number":"\u65e0\u6548\u53f7\u7801","jan":"\u4e00\u6708","jul":"\u4e03\u6708","jun":"\u516d\u6708","last_name_required":"\u59d3\u6c0f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","last_week":"\u4e0a\u5468","loading":"\u52a0\u8f7d\u4e2d...","manual_payment_guide":"\u624b\u52a8\u652f\u4ed8\u6307\u5357","mar":"\u4e09\u6708","may":"\u4e94\u6708","mon":"\u661f\u671f\u4e00","month":"\u6708","multi_templates":"\u9700\u8981\u591a\u4e2a\u6a21\u677f","no":"\u4e0d","nov":"\u5341\u4e00\u6708","oct":"\u5341\u6708","ok":"\u597d","password_character":"\u5bc6\u7801\u5fc5\u987b\u81f3\u5c11\u4e3a8\u4e2a\u5b57\u7b26\u3002","password_must_match":"\u5bc6\u7801\u548c\u5bc6\u7801\u786e\u8ba4\u5fc5\u987b\u5339\u914d\u3002","passwords":"\u5bc6\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","payment_not_complete":"\u652f\u4ed8\u672a\u5b8c\u6210","paypal_mode":"Paypal\u6a21\u5f0f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","paypal_secret":"Paypal\u79d8\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","paystack_key":"Paystack \u5bc6\u94a5","paystack_secret":"Paystack \u5bc6\u94a5","phone":"\u7535\u8bdd","phone_number_required":"\u7535\u8bdd\u53f7\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","plan_expire_notification":"\u8ba1\u5212\u5230\u671f\u901a\u77e5\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","privacy_policy":"\u9690\u79c1\u653f\u7b56","purchase":"\u8d2d\u4e70","remove":"\u79fb\u9664","sat":"\u661f\u671f\u516d","select_hour":"\u8bf7\u9009\u62e9\u65e5\u671f\u6216\u5c0f\u65f6","select_one_or_more":"\u9009\u62e9\u4e00\u4e2a\u6216\u591a\u4e2a\u529f\u80fd\u662f\u5fc5\u9700\u7684","sep":"\u4e5d\u6708","social_links_img_is_required":"\u793e\u4ea4\u94fe\u63a5\u56fe\u7247\u662f\u5fc5\u9700\u7684\u3002","social_links_is_required":"\u793e\u4ea4\u94fe\u63a5\u662f\u5fc5\u9700\u7684\u3002","stripe_secret":"Stripe\u79d8\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","subscriptions":"\u8ba2\u9605","successful":"\u6210\u529f","sun":"\u661f\u671f\u65e5","term_condition":"\u6761\u6b3e\u548c\u6761\u4ef6","testimonial":"\u63a8\u8350","the_term_conditions":"\u9700\u8981\u63a5\u53d7\u6761\u6b3e\u548c\u6761\u4ef6\u3002","this_week":"\u672c\u5468","thu":"\u661f\u671f\u56db","to":"\u5230","today":"\u4eca\u5929","too_long":"\u592a\u957f","too_short":"\u592a\u77ed","tue":"\u661f\u671f\u4e8c","unavailable":"\u4e0d\u53ef\u7528","upload_required":"\u4e0a\u4f20\u6587\u4ef6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","user":"\u7528\u6237","vcard_name":"VCard\u540d\u79f0","wed":"\u661f\u671f\u4e09","yes":"\u662f"}});
})();
